%define ver 3.0.3
%define RELEASE 1
%define rel %{?CUSTOM_RELEASE} %{!?CUSTOM_RELEASE:%RELEASE}

Summary: InfiniBand subnet manager and administration
Name: opensm
Version: %{ver}
Release: %rel%{?dist}
License: GPL/BSD
Group: System Environment/Daemons
URL: http://openib.org/
Source: http://openib.org/downloads/%{name}-%{ver}.tar.gz
BuildRoot: %{_tmppath}/%{name}-%{version}-%{release}-root-%(%{__id_u} -n)
BuildRequires: libibumad-devel
Requires: libibumad

%description
OpenSM provides an implementation of an InfiniBand Subnet Manager and
Administration. Such a software entity is required to run for in order
to initialize the InfiniBand hardware (at least one per each
InfiniBand subnet).

%package devel
Summary: Development files for OpenSM
Group: System Environment/Libraries
Requires: %{name} = %{version}-%{release} libibumad-devel

%description devel
Static libraries and header files for OpenSM.

%prep
%setup -q -n %{name}-%{ver}

%if %{?_with_console_socket:1}%{!?_with_console_socket:0}
%define _enable_console_socket --enable-console-socket
%endif
%if %{?_without_console_socket:1}%{!?_without_console_socket:0}
%define _disable_console_socket --disable-console-socket
%endif

%build
%configure \
        %{?_enable_console_socket} \
        %{?_disable_console_socket}
make %{?_smp_mflags}

%install
rm -rf $RPM_BUILD_ROOT
%makeinstall
rm -f $RPM_BUILD_ROOT%{_libdir}/*.la
etc=$RPM_BUILD_ROOT/%{_sysconfdir}
mkdir -p $etc/{init.d,sysconfig}
install -m 755 scripts/opensm.init $etc/init.d/opensm
install -m 755 scripts/opensm.sysconfig $etc/sysconfig/opensm

%clean
rm -rf $RPM_BUILD_ROOT

%post
/sbin/ldconfig
if [ -x /sbin/chkconfig ]; then
    /sbin/chkconfig --add opensm
    /sbin/chkconfig opensm off
fi

%postun -p /sbin/ldconfig

%files
%defattr(-,root,root,-)
%{_bindir}/opensm
%{_bindir}/osmtest
%{_libdir}/*.so.*
%{_mandir}/man8/*
%doc AUTHORS COPYING README
%config %{_sysconfdir}/init.d/opensm
%config(noreplace) %{_sysconfdir}/sysconfig/opensm

%files devel
%defattr(-,root,root,-)
%{_includedir}/infiniband/*
%{_libdir}/*.a
%{_libdir}/*.so
